--> Pralable :
-- USE BD_Air_France;

CREATE PROCEDURE S_PSP.GET_PERSONNE_TELEPHONE
       @MAJ_ONLY BIT = 0
AS
SET NOCOUNT ON;

-- positionnement du niveau d'isolation en versionnement des lignes
SET TRANSACTION ISOLATION LEVEL SNAPSHOT;

-- traitement en cas d'erreur
BEGIN TRY;

-- variables locales
DECLARE @JPT_ID BIGINT, 
        @PSP_ID INT, 
		@JPT_DH DATETIME2,
        @JPT_MODIF_TABLE CHAR(3), 
		@JPT_MODIF_NATURE CHAR(1);
-- dmarrage de la transaction
BEGIN TRANSACTION;

-- table de travail
CREATE TABLE #T (JPT_ID             BIGINT PRIMARY KEY,
                 PSP_ID             INT NOT NULL,
                 JPT_DH             DATETIME2 NOT NULL,
                 JPT_MODIF_TABLE    CHAR(3) NOT NULL,
                 JPT_MODIF_NATURE   CHAR(1) NOT NULL);

-- dversement des lignes  traiter dans la table de travail
INSERT INTO #T SELECT *
FROM S_ADM.T_A_JOURNALISATION_VM_PSP_TEL_JPT;

-- curseur de lecture des lignes de journalisation
DECLARE C CURSOR LOCAL FORWARD_ONLY STATIC READ_ONLY
FOR
   SELECT JPT_ID, PSP_ID, JPT_DH, JPT_MODIF_TABLE, JPT_MODIF_NATURE
   FROM #T
   ORDER BY JPT_DH;
OPEN C;
FETCH C INTO @JPT_ID, @PSP_ID, @JPT_DH, @JPT_MODIF_TABLE, @JPT_MODIF_NATURE;

-- lecture squentielle dans l'ordre chronologique de ce qu'il faut faire
WHILE @@FETCH_STATUS = 0
BEGIN

-- tlphone ajout, modifi ou supprim : on remet  jour tous les numros
   IF @JPT_MODIF_TABLE = 'TEL'
   BEGIN
      WITH
      T AS (SELECT PSP_ID, TEL_NUMERO
            FROM   S_PSP.T_TELEPHONE_TEL AS T
                   INNER JOIN S_PSP.T_R_TYPE_TELEPHONE_TTL AS TT
                          ON T.TTL_ID = TT.TTL_ID
            WHERE  TT.TTL_CODE = 'FIXE'
              AND  T.TEL_DEFAUT = 1),
      G AS (SELECT PSP_ID, TEL_NUMERO
            FROM   S_PSP.T_TELEPHONE_TEL AS T
                   INNER JOIN S_PSP.T_R_TYPE_TELEPHONE_TTL AS TT
                         ON T.TTL_ID = TT.TTL_ID
            WHERE  TT.TTL_CODE = 'MOBILE'
              AND  T.TEL_DEFAUT = 1),
      F AS (SELECT PSP_ID, TEL_NUMERO
            FROM   S_PSP.T_TELEPHONE_TEL AS T
                   INNER JOIN S_PSP.T_R_TYPE_TELEPHONE_TTL AS TT
                         ON T.TTL_ID = TT.TTL_ID
            WHERE  TT.TTL_CODE = 'FAX'
              AND  T.TEL_DEFAUT = 1)
      UPDATE V
      SET    NUMERO_FIXE = T.TEL_NUMERO,
             NUMERO_MOBILE = G.TEL_NUMERO,
             NUMERO_FAX = F.TEL_NUMERO
      FROM   S_PSP.T_VM_PERSONNE_TELEPHONE_PTP AS V
             INNER JOIN S_PSP.T_PERSONNE_PHYSIQUE_PSP AS P
                   ON V.PSP_ID = P.PSP_ID
             LEFT OUTER JOIN T
                   ON P.PSP_ID = T.PSP_ID
             LEFT OUTER JOIN G
                   ON P.PSP_ID = G.PSP_ID
             LEFT OUTER JOIN F
                   ON P.PSP_ID = F.PSP_ID
      WHERE V.PSP_ID = @PSP_ID;
   END;

-- personne ajoute, on ajoute une ligne dans la "vue"
   IF @JPT_MODIF_NATURE = 'I' AND @JPT_MODIF_TABLE = 'PSP'
   BEGIN
      INSERT INTO S_PSP.T_VM_PERSONNE_TELEPHONE_PTP
            (PSP_ID, PSP_NOM, PSP_PRENOM)
      SELECT PSP_ID, PSP_NOM, PSP_PRENOM
      FROM   S_PSP.T_PERSONNE_PHYSIQUE_PSP
      WHERE  PSP_ID = @PSP_ID;
   END;

-- personne supprime, on supprime la ligne dans la "vue"
   IF @JPT_MODIF_NATURE = 'D' AND @JPT_MODIF_TABLE = 'PSP'
   BEGIN
      DELETE FROM S_PSP.T_VM_PERSONNE_TELEPHONE_PTP
      WHERE  PSP_ID = @PSP_ID;
   END;

-- personne modifie, on modifie la ligne dans la "vue"
   IF @JPT_MODIF_NATURE = 'U' AND @JPT_MODIF_TABLE = 'PSP'
   BEGIN
      UPDATE S_PSP.T_VM_PERSONNE_TELEPHONE_PTP
      SET    PSP_NOM = T.PSP_NOM,
             PSP_PRENOM = T.PSP_PRENOM
      FROM   S_PSP.T_PERSONNE_PHYSIQUE_PSP AS T
      WHERE  T.PSP_ID = @PSP_ID;
   END; 

   FETCH C INTO @JPT_ID, @PSP_ID, @JPT_DH, @JPT_MODIF_TABLE, @JPT_MODIF_NATURE;

END; -- WHILE

CLOSE C;
DEALLOCATE C;

-- nettoyage de la table de journalisation
DELETE FROM S_ADM.T_A_JOURNALISATION_VM_PSP_TEL_JPT
WHERE  JPT_ID IN (SELECT JPT_ID FROM #T)

COMMIT;

END TRY
BEGIN CATCH
   IF XACT_STATE() <> 0
   ROLLBACK;
   DECLARE @MSG NVARCHAR(1024);
   SET @MSG = ERROR_MESSAGE();
   THROW 55555, @MSG, 16;
END CATCH

-- renvoi des donnes au plus synchrone
IF @MAJ_ONLY = 0
   SELECT *
   FROM   S_PSP.T_VM_PERSONNE_TELEPHONE_PTP;

-- remise au niveau d'isolation standard
SET TRANSACTION ISOLATION LEVEL READ COMMITTED;

GO